//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.12

import wesual.Ui 1.0

UiDialog {
    id : uiMessageBox

    property int iconType : Ui.MessageBoxWarningIcon

    width : 550

    headerDelegate  : null

    contentDelegate : Rectangle {
        property UiDialog dialog

        color          : UiColors.getColor(UiColors.HeaderGrey4)
        implicitHeight : content.implicitHeight + 23
        implicitWidth  : content.implicitWidth  + 30

        Column {
            id : content

            y       : 10
            spacing : 6

            anchors {
                left        : parent.left
                leftMargin  : 15
                right       : parent.right
                rightMargin : 15
            }

            Row {
                spacing : 3
                anchors {
                    left  : parent.left
                    right : parent.right
                }

                UiIcon {
                    id : icon

                    iconName : [ "", "ok", "warning", "error"][iconType]

                    iconSize  : UiIcon.Icon_32x32
                    visible   : uiMessageBox.iconType !== Ui.MessageBoxNoIcon
                    transform : Translate {
                        x : -1
                        y : 1
                    }
                }
                Text {
                    font  : UiFonts.getFont(UiFonts.Light, 18)
                    color : UiColors.getColor(UiColors.DialogHeaderText)
                    text  : dialog.label
                    width : parent.width - x
                    elide : Text.ElideRight
                    y     : 1

                    anchors.verticalCenter : parent.verticalCenter
                }
            }
            Text {
                id : instructionLabel

                font     : UiFonts.getFont(UiFonts.Light, 14)
                color    : UiColors.getColor(UiColors.DialogHeaderText)
                text     : dialog.instructionText
                visible  : text.length > 0
                wrapMode : Text.WordWrap
                linkColor : UiColors.getColor(UiColors.DarkerBlueGrey)

                anchors {
                    left  : parent.left
                    right : parent.right
                }

                onLinkActivated : Qt.openUrlExternally(link)
            }
        }
    }

    footerOptions : {
        "separatorLine" : false
    }

    // Don't reject on esape, click outside and close event by default
    flags : UiDialog.NoFlag
}
